<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

  <div class="page-content-wrapper">
    <header class="header">
      <div class="header-top">
        <div class="container">
          <div class="row-flex">
            <div class="col-logo col-auto">
                  <?php 
                    $custom_logo_id = get_theme_mod('custom_logo');
                    $image = wp_get_attachment_image_src( $custom_logo_id , 'full' );
                  ?>
                  <a href="<?php echo home_url(); ?>">
                    <img class="light-logo" src="<?php print $image[0]; ?>">
                  </a>
            </div>
            <div class="search-toggle"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32px" height="32px"><path fill="3F5383" d="M 19 3 C 13.488281 3 9 7.488281 9 13 C 9 15.394531 9.839844 17.589844 11.25 19.3125 L 3.28125 27.28125 L 4.71875 28.71875 L 12.6875 20.75 C 14.410156 22.160156 16.605469 23 19 23 C 24.511719 23 29 18.511719 29 13 C 29 7.488281 24.511719 3 19 3 Z M 19 5 C 23.429688 5 27 8.570313 27 13 C 27 17.429688 23.429688 21 19 21 C 14.570313 21 11 17.429688 11 13 C 11 8.570313 14.570313 5 19 5 Z"/></svg></div>
            <div class="col-search col-auto">
              <div class="search-icon">
                <?php get_search_form(); ?>
              </div>
            </div>

          </div>
        </div>
      </div>
      <div class="main-navigation">
        <div class="container">
          <div class="row-flex">
            <div class="navigation-toggle">
              <div class="bars">
                <span></span>
                <span></span>
                <span></span>
              </div>
              <div class="text"><span>Menu</span></div>
            </div>
            <div class="navigation">
              <?php wp_nav_menu(array('theme_location'=>'header'));?>
              <div class="navigation-close">
              <div class="bars">
                <span></span>
                <span></span>
              </div>
            </div>
            </div>
            <?php 
              $social_title = get_field('social_title', 'options');
              $linkedin = get_field('linkedin', 'options');
              $youtube = get_field('youtube', 'options');
            ?>
            <?php if ((!empty($linkedin)) && (!empty($social_title))) {  ?>
            <div class="linkedin-text">
              <p><a target="_blank" href="<?php print $linkedin; ?>"><?php print $social_title; ?><i class="fab fa-linkedin-in"></i></a></p>
              <?php if (!empty($youtube)) {  ?>
              <p><a target="_blank" href="<?php print $youtube; ?>"><i class="fab fa-youtube"></i></a></p>
              <?php } ?>
            </div>
            <?php } ?>
          </div>
        </div>
      </div>
    </header>
    
     
              