<div class="wrap bialty-containter">

    <?php include 'layout/top.view.php' ?>

    <div class="bialty-faq bialty-containter">

    <div class="faq-container">
        <div class="bialty-q">
            <?php echo esc_html__( '1.What is alt text?', "bulk-image-alt-text-with-yoast" ); ?>
        </div>
        <div class="bialty-a">
            <p>
                <?php echo esc_html__( 'Alt text (alternative text), also known as "alt attributes", “alt descriptions,” and technically incorrectly as "alt tags,” are used within an HTML code to describe the appearance and function of an image on a page.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>
            <p>
                <strong><?php echo esc_html__( 'How to use Alt text:', "bulk-image-alt-text-with-yoast" ); ?></strong>
            </p>
            <ul>
                <li><?php echo esc_html__( 'Adding alternative text to photos is first and foremost a principle of web accessibility. Visually impaired users using screen readers will be read an alt attribute to better understand an on-page image.', "bulk-image-alt-text-with-yoast" ); ?></li>
                <li><?php echo esc_html__( 'Alt tags will be displayed in place of an image if an image file cannot be loaded.', "bulk-image-alt-text-with-yoast" ); ?></li>
                <li><?php echo esc_html__( 'Alt tags provide better image context/descriptions to search engine crawlers, helping them to index an image properly.', "bulk-image-alt-text-with-yoast" ); ?></li>
            </ul>

            <strong>Source: https://moz.com/learn/seo/alt-text</strong>
        </div>
    </div>

    <div class="faq-container">
        <div class="bialty-q">
            <?php echo esc_html__( 'Appropriate length?', "bulk-image-alt-text-with-yoast" ); ?>
        </div>
        <div class="bialty-a">
            <p>
                <?php echo esc_html__( 'Google seemed to count the first 16 words in the ALT tag and interestingly in the snippet Google uses, it does seem to completely cut off the rest of the ALT and from the 17th word. Having 16 words to work with might prove very useful if you are using ALT tags to describe more complex images. There is potentially plenty of available space to describe images properly for accessibility purposes AND SEO impact.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>

            <p><strong>Source: https://www.hobo-web.co.uk/how-many-words-in-alt-text-for-google-yahoo-bing/</strong></p>
        </div>
    </div>

    <div class="faq-container">
        <div class="bialty-q">
            <?php echo esc_html__( 'How Image Alt Tags and Meta Data Help SEO', "bulk-image-alt-text-with-yoast" ); ?>
        </div>
        <div class="bialty-a">
            <p>
                <?php echo esc_html__( 'Optimizing your images for SEO helps crawlers better index your web pages, which in turn can give you a rankings boost because it can make the page more relevant to users.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>
            <p>
                <?php echo esc_html__( 'Let’s say a searcher needs plumber repairs for a clogged bathroom drain. Google has to choose between two web pages from different companies, both of which have equal ranking factors.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>
            <p>
                <?php echo esc_html__( 'As the crawler reads through the first page, it doesn’t identify any image alt-tags, therefore, it assumes the images (if there are any) do not add page-specific value. On the second page, however, the crawler locates five images, each one with a full description of what the image is showing. All five images’ alt tags supplement the rest of the text on the page.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>
            <p>
                <?php echo esc_html__( 'Since Google is all about spitting out the results you’ll most likely jive with, it’s going to go with the article that it thinks is more relevant.', "bulk-image-alt-text-with-yoast" ); ?>
            </p>
            <strong>NEED help ? Please contact us at support@bialty.com</strong>
        </div>
    </div>

</div>


</div>