<?php

//include js and css
function wp_theme_enqueue() {
  wp_enqueue_style('bootstrap', get_template_directory_uri() . '/bootstrap/bootstrap.min.css');
  wp_enqueue_style('swipercss', get_template_directory_uri() . '/assets/css/swiper.min.css');
  wp_enqueue_style('font-awesome6','https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css');
  wp_enqueue_style('style', get_template_directory_uri() . '/assets/css/style.css');
/*  wp_enqueue_style('new', get_template_directory_uri() . '/new.css');*/
  wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/bootstrap/bootstrap.min.js', array('jquery'), '', true );
  wp_enqueue_script( 'swiperjs', get_template_directory_uri() . '/assets/js/swiper.min.js', array('jquery'), '', true );
  wp_enqueue_script( 'customjs', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '', true );
  wp_enqueue_script( 'autoplayjs', get_template_directory_uri() . '/assets/js/autoplay.js', array('jquery'), '', true );
}
add_action('wp_enqueue_scripts', 'wp_theme_enqueue');

function wp_add_support() {
  add_theme_support( 'custom-logo' );
  add_theme_support( 'title-tag' );
  add_theme_support( 'post-thumbnails' );
}
add_action( 'after_setup_theme', 'wp_add_support' );

//menu select code:-
register_nav_menus( array(
    'header' => 'Main Menu',
    'footer' => 'Footer Menu'
  ) ); 
  //end

//add footer logo
function wp_customize_register( $wp_customize ) {   
  $wp_customize->add_setting('footer_logo');
  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_logo', array(
      'label' => 'Footer Logo',
      'section' => 'title_tagline', 
      'settings' => 'footer_logo',
      'priority' => 8 
  )));
}
add_action( 'customize_register', 'wp_customize_register' );

//convert date en to fr
function dateToFrench($date, $format){
  $english_days = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
  $french_days = array('lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi', 'dimanche');
  $english_months = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
  $french_months = array('Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre');
  $en_small_months = array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
  $fr_small_months = array('Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Juin', 'Juil', 'Août', 'Sept', 'Oct', 'Nov', 'Déc');
  return str_replace($english_months, $french_months, str_replace($english_days, $french_days,str_replace($en_small_months,$fr_small_months,date($format, strtotime($date) ))  ) );
}
//end

//custom pagination
function custom_pagination($current_page,$total_pages){
  $output = '';
  $output .= '<div class="pagination-wrap">';
  $big = 999999999; // need an unlikely integer
  $output .= '<div class="fraction-pagination-wrap"><span>page '.$current_page.' sur '.$total_pages.'</span></div>';
  $output .=  paginate_links( 
    array(
      'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
      'format' => '?paged=%#%',
      'current' => $current_page,
      'total' =>  $total_pages,
      'prev_text'    => '«',
      'next_text'    => '»',
      'show_all' => True,
    ) 
  );
  $output .= '</div>';
  return $output;
}
//end

//company logo slider
function realiser_slide(){
  $slider_content = get_field('slider_content' ,'options');
  $output = '';
  if (!empty($slider_content)) {
    $output .= '<div class="client-slider">
                  <div class="container">
                    <div class="swiper logoSwiper">
                      <div class="swiper-wrapper">';
          foreach ($slider_content as $value) {
            $logo = $value['logo'];
            if (!empty($logo)) {
              $logo_url = $logo['url'];
            }
            $url = $value['url'];
            if ((!empty($logo_url)) && (!empty($url))) {
              $output .= '<div class="swiper-slide">
                            <div class="logo-link">
                              <a href="'.$url.'"><img src="'.$logo_url.'"></a>
                            </div>
                         </div>';
            }             
          }
          $output .= '</div>
                    </div>
                  </div>
                  <div class="swiper-buuton-outer">
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                  </div>
                </div>';
  }
  return $output;
}
add_shortcode( 'logo_link', 'realiser_slide' );
//end

function reference_slide(){
  $reference_content = get_field('nos_reference' ,'options');
  $output = '';
  if (!empty($reference_content)) {
    $output .= '<div class="client-slider">
                  <div class="container">
                    <div class="swiper refSwiper">
                      <div class="swiper-wrapper">';
          foreach ($reference_content as $value) {
            $img = $value['image'];
            if (!empty($img)) {
              $img_url = $img['url'];
            }
            $text = $value['text'];
             $output .= '<div class="swiper-slide">';
                          if (!empty($img_url)) {
                $output .= '<div class="logo-link">
                              <img src="'.$img_url.'">
                            </div>';
                          }
                          if (!empty($text)) {
                $output .= '<div class="text">'.$text.'</div>';
                          }                    
             $output .= '</div>';
          }
          $output .= '</div>
                    </div>
                  </div>
                  <div class="swiper-buuton-outer">
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                  </div>
                </div>';
  }
  return $output;
}
add_shortcode( 'nos_reference', 'reference_slide' );

//publication detail page
function publication_detail(){ 
  $title = get_the_title();
  $date = get_the_date('d/m/Y');
  $img = get_the_post_thumbnail_url();
  $p_date = get_field('publication_date' , get_the_ID());
  $new_format = Date('j/m/Y', strtotime($p_date));
  $output = '';
  $output .= '<div class="title-date-wrapper">
                  <div class="title">
                    <h1>'.$title.'</h1>
                  </div>';
                  if (!empty($p_date)) {
               $output .='<div class="date">
                              <p>'.$new_format.'</p>
                            </div>';
            }else{
              $output .='<div class="date">
                              <p>'.$date.'</p>
                            </div>';
            }
    $output .='</div>
                <div class="image">
                  <img src="'.$img.'">
                </div>';           
  return $output;
}
add_shortcode( 'pub_detail', 'publication_detail' );
//end

//first latest post for publication listing page
function featured_post(){
  $output = '';
  $output .= '<div class="promoted-publication-wrapper">
             <div class="promoted-publication-inner">';
              $args = array(
              'post_type'=> 'publications',
              'orderby'    => 'ID',
              'post_status' => 'publish',
              'order'    => 'DESC',
              'posts_per_page' => 1,
              'meta_query' => array(
                                   array( 
                                        'key' => 'featured_post',
                                        'value' => '1',
                                        'compare' => '='
                                        )
                                  )
              
              );
              $result = new WP_Query( $args );
              if ( $result-> have_posts() ) : 
               while ( $result->have_posts() ) : $result->the_post(); 
               $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'full' ); 
               $f_icon = get_field('featured_icon');
               if(!empty($f_icon)){
                 $f_icon_url = $f_icon['url'];
               }
               $title = get_the_title();
               $date = get_the_date('d/m/y');
               $p_date = get_field('publication_date');
               $new_format = Date('d/m/y', strtotime($p_date));
     $output .='<div class="caption-wrapper">';
                if (!empty($f_icon_url)) {
        $output .='<div class="icon">
                    <img src="'.$f_icon_url.'">
                  </div>';
                }
        $output .='<div class="title">
                    <a href="'.get_the_permalink().'"><h2>'.$title.'</h2></a>
                  </div>';
                if(!empty($p_date)) {
        $output .='<div class="date">
                    <p>'.$new_format.'</p>
                  </div>';
                }else{
        $output .='<div class="date">
                    <p>'.$date.'</p>
                  </div>';
                }
        $output .='<div class="text">
                    <p>'.get_the_excerpt().'</p>
                  </div>
                  <div class="btn-link">
                    <a href="'.get_the_permalink().'">En savoir plus</a>
                  </div>
                </div> 
                <div class="image-wrapper">';
                  if (!empty($url)) {
        $output .='<div class="image">
                    <a href="'.get_the_permalink().'"><img src="'.$url.'"></a>
                  </div>';
                  }
        $output .='</div>';
              endwhile; 
     endif; wp_reset_postdata();
     $output .= '</div>
             </div>';
return $output;
}
add_shortcode('feature_post' , 'featured_post');
//end

//all publication for listing page
function publication_post(){
setlocale(LC_TIME, "fr_FR");

  $output = '';
  $output .= '<div class="related-publication-wrapper">
                <div class="related-publication-inner">';
                  $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;         
                  $args = array(
                  'post_type'=> 'publications',
                  'orderby'    => 'ID',
                  'post_status' => 'publish',
                  'orderby'        => 'meta_value', 
                  'meta_key'       => 'publication_date', 
                  'order'          => 'DESC', 
                  'posts_per_page' => 9,
                  'paged' => $paged
                  );
                  $result = new WP_Query( $args );
                  if ( $result-> have_posts() ) :
                  $output .='<div class="row">'; 
                   while ( $result->have_posts() ) : $result->the_post();  
                   $img = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'publication-cards' );
                   $url = '';
                   if (!empty($img)) {
                      $url = $img[0];
                    } 
                   $title = get_the_title();
                   $date = get_the_date();
                   $fr_date = dateToFrench($date, 'd M Y');
                   $p_date = get_field('publication_date');
                   //$new_format = Date('d M Y', strtotime($p_date));
                   $frn_date = dateToFrench($p_date, 'd M Y');
       $output .='<div class="col-md-6 col-lg-4">
                    <div class="publication-card">';
                      if (!empty($url)) {
            $output .='<div class="image-wrapper">
                        <div class="image">
                           <a href="'.get_the_permalink().'"><img src="'.$url.'"></a>
                        </div>
                      </div>';
                      }
            $output .='<div class="caption-wrapper">
                        <div class="title">
                          <a href="'.get_the_permalink().'"><h2>'.$title.'</h2></a>
                        </div>';
          if(!empty($p_date)){
              $output .='<div class="date">
                          <p>'.$frn_date.'</p>
                        </div>';
          }else{
             $output .='<div class="date">
                          <p>'.$fr_date .'</p>
                        </div>';
          }
                
              $output .='<div class="text">
                          <p>'.get_the_excerpt().'</p>
                        </div>
                        <div class="btn-link">
                          <a href="'.get_the_permalink().'">En savoir plus</a>
                        </div>
                      </div>
                    </div>
                  </div>';


      endwhile;
      $output .= '</div>';
       $total_pages = $result->max_num_pages;
          if ($total_pages > 1){
            $current_page = max(1, get_query_var('paged'));
            $output .= custom_pagination($current_page,$total_pages);
          }   
     endif; wp_reset_postdata();
     $output .= '</div>
             </div>';
return $output;
}
add_shortcode('all_publications' , 'publication_post');
//end



//related publcation
function related_publication(){
  $output = '';
  $related_publicatio = get_field('related_publicatio' , get_the_ID());
  $output .= '<div class="related-publication-wrapper">
                <div class="related-publication-inner">';
  if (!empty($related_publicatio)) {
        $output .='<div class="row">';
    foreach ($related_publicatio as  $value) {
      $id = $value->ID;
      $image = wp_get_attachment_image_src(get_post_thumbnail_id($id),'full'); 
      if (!empty($image)) {
      $image_url = wp_get_attachment_image_src(get_post_thumbnail_id($id),'full')[0]; 
      } 
   $output .='<div class="col-md-6 col-lg-4">
                <div class="publication-card">
                  <div class="image-wrapper">
                    <div class="image">
                       <a href="'.get_the_permalink($id).'"><img src="'.$image_url.'"></a>
                    </div>
                  </div>
                  <div class="caption-wrapper">
                    <div class="title">
                    <h4><a href="'.get_the_permalink($id).'">'.get_the_title($id).'</a></h4>
                    </div>
                    <div class="date">
                      <p>'.get_the_date('d M Y' , $id).'</p>
                    </div>
                    <div class="text">
                      <p>'.get_the_excerpt($id).'</p>
                    </div>
                    <div class="btn-link">
                      <a href="'.get_the_permalink($id).'">En savoir plus</a>
                    </div>
                  </div> 
                </div>
              </div>';
    }
    $output .= '</div>';
  }
   $output .= '</div>
             </div>';  
 
return $output;
}
add_shortcode('related_publication_post' , 'related_publication');
//end

//comment form for publication detail page
function publication_comment(){ 
 $output = '';

  $output .= comment_form();            
return $output;
}
add_shortcode( 'pub_comment', 'publication_comment' );
//end