<?php get_header(); ?>
<div class="search-result-wrapper">
  <div class="container">
    <div class="search-result-inner">
      <div class="search-box-section">
        <div class="row">
          <div class="search-result-left">
            <?php 
              $s=get_search_query();
              $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
              $args = array(
                's' =>$s,
                'paged'    => $paged,
                'posts_per_page'=>5
              );
            ?>
            <?php
              $the_query = new WP_Query( $args );
              if( $the_query->have_posts()){
                while( $the_query->have_posts()){
                  $the_query->the_post();
                  $id = get_the_ID();
                  $excerpt = get_the_excerpt($id);
                  $excerpt = wp_trim_words($excerpt,30);
                  $sinContent = get_the_title();
                  $url = wp_get_attachment_url( get_post_thumbnail_id($id), 'thumbnail' );
            ?>
                  <div class="searched-results">
                    <?php if (!empty($url)) { ?>
                      <div class="img-wrapper">
                        <img src="<?php print $url; ?>">
                      </div>
                    <?php } ?>
                    <div class="text-wrapper">
                      <div class="title">
                        <a href="<?php print get_permalink($id); ?>"><h2><?php print $sinContent; ?></h2></a>
                      </div>
                      <div class="date">
                        <span><?php print get_the_date( 'd-M-Y' ); ?></span>
                      </div>
                      <div class="desc"><?php print $excerpt; ?></div>
                    </div>
                    <div class="link">
                      <a href="<?php print get_permalink($id); ?>"></a>
                    </div>
                  </div>
                   <?php  } ?>
                  <div class="pagination-result-section">
                    <div class="pagination-wrapper">
                      <?php
                        $total_pages = $the_query->max_num_pages;
                        if ($total_pages > 1){
                          $current_page = max(1, get_query_var('paged'));
                          print custom_pagination($current_page,$total_pages);
                        }
                      ?>
                    </div> 
                  </div>
            <?php  }else{  ?>
              <div class="result-not-found">
                  <p>Aucun résultat</p>
              </div>
            <?php }//else  ?>
            
          </div>
          <div class="search-result-right">
            <div class="search-title-section">
              <div class="main-title-center main-title-type-2 main-title">
                <?php print get_search_form(); ?>
              </div>
              <div class="recent-article">
                <h4>Articles récents</h4>
              </div>
              <?php 
                $args = array(
                  'post_type'=> 'publications',
                  'orderby'    => 'ID',
                  'post_status' => 'publish',
                  'order'    => 'DESC',
                  'posts_per_page' => 10
                );  
              ?>
            <?php
              $the_query = new WP_Query( $args );
              if( $the_query->have_posts()){
                while( $the_query->have_posts()){
                  $the_query->the_post();
                  $id = get_the_ID();
                  $excerpt = get_the_excerpt($id);
                  $excerpt = wp_trim_words($excerpt,30);
                  $sinContent = get_the_title();
            ?>
                  <div class="searched-results">
                    <div class="text-wrapper">
                      <div class="title">
                        <a href="<?php print get_permalink($id); ?>">
                          <?php print $sinContent; ?>
                        </a>
                      </div>
                    </div>
                  </div>
                   <?php  } ?>
              <?php  }else{  ?>
              <div class="result-not-found">
                  <p>Aucun résultat</p>
              </div>
            <?php }//else  ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php get_footer(); ?>

